/////////////////////////////////////////////////////////////////////////////////

// Original obtained from GlsSandbox.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// The originals of these shaders did not take gl_FragCoord.w  into
// account so the iStripper scale attribute would  have  no  effect
// when used ina scene node that used one of them. I have therefore
// performed a global replace to substitute scaled_gl_FragCoord for
// gl_FragCoord and declare it here. TheEmu 2016/12/15

#define scaled_gl_FragCoord vec4(gl_FragCoord.xyz*gl_FragCoord.w,1.0)

// Use defines here rather than edit the body of the code.

#define time u_Elapsed
#define resolution u_WindowSize
#define mouse vec2(0.0,0.0)
#define surfacePosition vec2(2.0*scaled_gl_FragCoord.xy/resolution-1.0)

/////////////////////////////////////////////////////////////////////////////////

#ifdef GL_ES
precision mediump float;
#endif

// uniform float time;
// uniform vec2 mouse;
// uniform vec2 resolution;
 
vec3 pin(vec3 v)
{
	vec3 q = vec3(0.0);
	
	q.x = sin(v.x)*0.5+0.5;
	q.y = sin(v.y+1.0471975511965977461542144610932)*0.5+0.5;
	q.z = sin(v.z+4.1887902047863909846168473723972)*0.5+0.5;
	
	return normalize(q);
}
 
vec3 spin(vec3 v)
{
	for(int i = 0; i <4; i++)
	{
		v=pin(v.yzx*6.283185307179586476925286766559);
	}
	return v.zxy;
}
 
float map(vec3 p) {
	p=1.5*pin(p)-p;
	return sin((cos(p.x)*0.75 + sin(p.y*0.75)*.75 + sin(p.z)*0.75)/1.5707963267948966192313216916398);
}
 
 
vec2 rot(vec2 r, float a) {
	return vec2(
		cos(a) * r.x - sin(a) * r.y,
		sin(a) * r.x + cos(a) * r.y);
}
 
void main( void ) {
	vec2 uv  = ( scaled_gl_FragCoord.xy / resolution.xy ) * 2.0 - 1.0;
	uv.x *= resolution.x / resolution.y ;
	vec3 dir = normalize(vec3(uv, 0.5));
	dir.zy = rot(dir.zy, time * 0.2);
	dir.xz = rot(dir.xz, time * 0.1); 
	dir.xy = rot(dir.xy, sin(time*0.125)*3.1415926535897932384626433832795) ;
	vec3 pos = vec3(0, 0, time * 2.0);
	float t = 0.0;
	for(int i = 0 ; i < 200; i++) {
		float temp = map(pos + dir * t) * 0.75;
		if(temp < 0.001) break;
		t += temp;
		dir.xy=rot(dir.xy,temp*0.05);
		dir.yz=rot(dir.yz,temp*0.05);
		dir.zx=rot(dir.zx,temp*0.05);
	}
	vec3 ip = pos + dir * t;
	gl_FragColor = vec4((vec3( map(ip + 0.2) + t * 0.02) + (dir*spin(ip))), 1.0);
   gl_FragColor *= gl_Color; // TheEmu 2016/12/15
 
}
